# Contributing Guidelines for Horilla

Thank you for considering contributing to Horilla! We welcome your input and appreciate the community effort to make this project even better.

## How to Contribute

1. **Fork the Repository:**
   - Fork the Horilla repository on GitHub to your own space.

2. **Clone the Repository:**
   - Clone the forked repository to your local machine.

     ```bash
     git clone https://github.com/your-username/Horilla.git
     ```

3. **Create a Branch:**
   - Create a new branch for your feature or bug fix.

     ```bash
     git checkout -b feature-or-bugfix-branch
     ```

4. **Make Changes:**
   - Make your changes and ensure that your code adheres to the project's coding standards.

5. **Commit Changes:**
   - Commit your changes with a clear and descriptive commit message.

     ```bash
     git commit -m "Add feature X"
     ```

6. **Push Changes:**
   - Push your changes to your forked repository on GitHub.

     ```bash
     git push origin feature-or-bugfix-branch
     ```

7. **Create a Pull Request:**
   - Open a pull request on the official Horilla repository.
   - Provide a clear title and description for your pull request.
   - Reference any relevant issues in your pull request description.

## Code Style and Guidelines

- Follow the [PEP 8](https://pep8.org/) style guide for Python code.
- Write clear, concise, and meaningful commit messages.
- Keep code changes focused and ensure they serve a specific purpose.

## Issues

- If you find a bug or have a feature request, please open an issue on GitHub.
- Clearly describe the issue or feature, providing as much detail as possible.
- If you are fixing a bug, reference the issue in your pull request.

## Community Guidelines

- Be respectful and considerate of others.
- Provide constructive feedback.
- Encourage a positive and inclusive community.

Thank you for your contributions to Horilla! Together, we can build a better and more efficient HR management solution using Django.
